<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('summary');
            $table->longText('description')->nullable();
            $table->date('event_date');
            $table->time('event_time'); //00:00:00
            $table->string('organizer');
            $table->string('location');
            $table->string('email');
            $table->string('phone');
            $table->string('website');
            $table->string('sponsor');
            $table->string('event_speaker');
            $table->string('photo')->nullable();
            $table->string('tags')->nullable();
            $table->unsignedBigInteger('event_cat_id')->nullable();
            $table->unsignedBigInteger('event_tag_id')->nullable();
            $table->unsignedBigInteger('added_by')->nullable();
            $table->enum('status',['active','inactive'])->default('active');
            $table->foreign('event_cat_id')->references('id')->on('event_categories')->onDelete('SET NULL');
            $table->foreign('event_tag_id')->references('id')->on('event_tags')->onDelete('SET NULL');
            $table->foreign('added_by')->references('id')->on('users')->onDelete('SET NULL');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('events');
    }
}
