<?php

namespace App\Http\Controllers;

use App\Models\SectionImage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Inertia\Inertia;
use Illuminate\Validation\ValidationException;

class SectionImageController extends Controller
{
    public function uploadMenuBackgroundDrinks(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);
        $path = $request->file('file')->store('home-images', 'public');
        $filename = basename($path);
        return response()->json(['filename' => 'home-images/' . $filename]);
    }

    public function uploadMenuBackgroundDesserts(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);
        $path = $request->file('file')->store('home-images', 'public');
        $filename = basename($path);
        return response()->json(['filename' => 'home-images/' . $filename]);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(SectionImage $SectionImage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit()
    {
        //
        $section_images = SectionImage::firstOrFail();

        return Inertia::render('section_images/SectionImage', [
            'section_images' => $section_images,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        //
        try {
            DB::beginTransaction();

            $validatedData = $request->validate([
                'home_about'              => 'nullable|string',
                'about_page'              => 'nullable|string',
                'besides_mission'         => 'nullable|string',
                'hero_background'         => 'nullable|string',
                'menu_background'         => 'nullable|string',
                'menu_background_drinks'  => 'nullable|string',
                'menu_background_desserts'=> 'nullable|string',
                'cta_background'          => 'nullable|string'
            ]);

            // Retrieve the sole contact record. Throws a 404 if not found.
            $SectionImage = SectionImage::firstOrFail();

            // Update all fields directly
            $SectionImage->update($validatedData);

            DB::commit();

            return Redirect::back()->with('success', [
                'message' => 'Home images updated successfully',
                'check'   => false,
            ]);
        } catch (ValidationException $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Validation error: ' . $e->getMessage(),
                'check'   => $e->getMessage(),
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Error: ' . $e->getMessage(),
                'check'   => $e->getMessage(),
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SectionImage $SectionImage)
    {
        //
    }

    public function uploadImage(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5048',
        ]);
        $path = $request->file('file')->store('home-images', 'public');  
        $filename = basename($path); 

        return response()->json(['filename' => 'home-images/' . $filename]); 
    }
}
