<?php

namespace App\Http\Controllers;

use App\Models\Subscriber;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Http;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use DB;
use App\Traits\DeleteModelTrait; 

class SubscriberController extends Controller
{
    use DeleteModelTrait;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

public function store(Request $request)
{
    try {
        DB::beginTransaction();

        // Validate the form data, including the Turnstile token
        $validatedData = $request->validate([
            'email' => 'required|email|unique:subscribers,email',
            // 'turnstile_token' => 'required|string',
        ]);

        // Verify the Turnstile token with Cloudflare
        // $turnstileSecretKey = config('services.turnstile.secret');
        // $response = Http::asForm()->post('https://challenges.cloudflare.com/turnstile/v0/siteverify', [
        //     'secret' => $turnstileSecretKey,
        //     'response' => $validatedData['turnstile_token'],
        //     'remoteip' => $request->ip(),
        // ]);

        // $responseBody = $response->json();

        // if (!$responseBody['success']) {
        //     // If Turnstile verification fails, throw a validation exception
        //     throw ValidationException::withMessages([
        //         'turnstile' => 'CAPTCHA verification failed.',
        //     ]);
        // }

        // Create a new subscriber
        $subscriber = new Subscriber;
        $subscriber->email = $validatedData['email'];
        $subscriber->save();

        DB::commit();

        // Redirect back with a success message
        return Redirect::back()->with('mail_success', [
            'message' => 'Subscribed to newsletter successfully',
            'check' => false,
        ]);
    } catch (ValidationException $e) {
        DB::rollBack();

        // Redirect back with validation errors
        return Redirect::back()->withErrors($e->errors())->withInput();
    } catch (\Exception $e) {
        DB::rollBack();

        // Redirect back with a generic error message
        return Redirect::back()->with('error', [
            'message' => 'Error: ' . $e->getMessage(),
            'check' => $e->getMessage(),
        ])->withInput();
    }
}


    /**
     * Display the specified resource.
     */
    public function show(Subscriber $subscriber)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Subscriber $subscriber)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Subscriber $subscriber)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        return $this->deleteModel($id, new Subscriber());
    }

    public function fetchSubscribers()
    {
        // Fetch all subscribers
        $subscribers = subscriber::orderBy('created_at', 'desc')->get();
        return Inertia::render('Admin/Pages/subscribers/Subscriber', [
            'subscribers' => $subscribers->map(function ($subscriber) {
                return $subscriber->only('id','email','created_at');
            }),
        ]);
    }
}
