<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

use App\Models\Booking;


class BookingConfirmationMail extends Mailable
{
    use Queueable, SerializesModels;
    public $bookingData;


    /**
     * Create a new message instance.
     */
    public function __construct(Booking $booking)
    {
        //
        $this->bookingData = $booking;
    }

    public function build()
    {
        $companyInfo = \App\Models\CompanyInformation::first();
        
        return $this->subject("Your Booking Confirmation - Matergo Hotel")
                    ->replyTo($this->bookingData->email, $this->bookingData->full_name) 
                    ->view('emails.booking_confirmation', [
                        'companyInfo' => $companyInfo
                    ]);
    }

    
}
