<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EventRoom extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'primary_photo',
        'price_fbu',
        'price_usd',
        'price_eur',
        'short_description',
        'full_description',
        'capacity',
        'layouts',
        'equipment',
        'gallery',
        'status',
    ];

    protected $casts = [
        'layouts' => 'array',
        'equipment' => 'array',
        'gallery' => 'array',
        'price_fbu' => 'decimal:2',
        'price_usd' => 'decimal:2',
        'price_eur' => 'decimal:2',
        'status' => 'boolean',
    ];

    public function bookings()
    {
        return $this->morphMany(Booking::class, 'bookable');
    }
}
