<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Contracts\Auditable;
use App\Models\Category;


class Post extends Model implements Auditable
{
    //
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'title',
        'description',
        'photo',
        'status',
        'tags',

    ];

    protected $casts = [
        'tags' => 'array',
    ];

    public function categories()
    {
        return $this->belongsToMany(Category::class);
    }
}
