<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Redirect;

trait DeleteModelTrait
{
    /**
     * Generic delete method for models
     * 
     * @param int $id
     * @param Model $model
     */
    public function deleteModel($id, Model $model)
    {
        $record = $model->find($id);

        if (!$record) {
            return Redirect::back()->with('error', [
                "message" => class_basename($model) . " not found."
            ]);
        }

        $record->delete();
        return Redirect::back()->with('success', [
            "message" => class_basename($model) . " deleted."
        ]);
    }
}