<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accommodations', function (Blueprint $table) {
            $table->id();
            $table->string('room_name');
            $table->string('primary_photo')->nullable();
            $table->decimal('price_fbu', 10, 2)->nullable();
            $table->decimal('price_usd', 10, 2)->nullable();
            $table->text('description')->nullable();
            $table->longText('full_description')->nullable();
            $table->string('size')->nullable();
            $table->string('bed_type')->nullable();
            $table->string('view')->nullable();
            $table->json('amenities')->nullable();
            $table->json('gallery')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accommodations');
    }
};
