<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            // Add room_id for specific room booking (nullable for backward compatibility)
            $table->unsignedBigInteger('room_id')->nullable()->after('accommodation_id');
            
            // Add guest count fields
            $table->unsignedInteger('number_of_adults')->default(1)->after('number_of_people');
            $table->unsignedInteger('number_of_children')->default(0)->after('number_of_adults');

            // Foreign key constraint
            $table->foreign('room_id')
                ->references('id')
                ->on('rooms')
                ->onDelete('set null');

            // Index for faster queries
            $table->index('room_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            $table->dropForeign(['room_id']);
            $table->dropIndex(['room_id']);
            $table->dropColumn(['room_id', 'number_of_adults', 'number_of_children']);
        });
    }
};
