import React, { useEffect } from "react";
import { Head, usePage } from "@inertiajs/react";
import Nav from "../components/Nav";
import SideBar from "../components/SideBar";

export default function DashboardLayout({ children }) {
    const { url } = usePage(); // Grab the current URL from Inertia
    useEffect(() => {
        const scripts = [
            "/assets/admin/js/apps.js",
        ];

        const loadResource = (type, src) => {
            return new Promise((resolve, reject) => {
                const element = document.createElement("script");
                element.src = src;
                element.async = false;
                element.onload = resolve;
                element.onerror = reject;
                document.head.appendChild(element);
            });
        };

        const loadAllResources = async () => {
            try {
                for (const script of scripts) {
                    await loadResource("js", script);
                }
            } catch (error) {
                console.error("Failed to load resources", error);
            }
        };

        loadAllResources();
    }, [url]); // dependency on 'url' means effect runs on navigation
return (
    <>
    <div className="vertical  dark">
        <div className="wrapper">
            <Nav />
            <SideBar />
            <main role="main" className="main-content">
            {children}
            </main>
        </div>
    </div>  
    </>
);
}