import { useForm } from "@inertiajs/react";

export default function Reset({ token, email: defaultEmail }) {
  const { data, setData, post, processing, errors } = useForm({
    token: token || '',
    email: defaultEmail || '',
    password: '',
    password_confirmation: '',
  });

  const submit = (e) => {
    e.preventDefault();
    post('/admin/reset-password');
  };

  return (
    <div className="wrapper vh-100">
      <div className="row align-items-center h-100">
        <form className="col-lg-3 col-md-4 col-10 mx-auto text-center" onSubmit={submit}>
          <img src="/assets/user/images/matergo_website_logo.png" alt="Matergo Hotel" className="navbar-brand mx-auto mt-2 flex-fill text-center" />
          <h2 className="my-3">Set New Password</h2>
          {errors.email && (
                <div className="alert alert-danger">
                    {errors.email}
                </div>
            )}
          <p className="text-muted">Enter your new password below to reset your account access.</p>

          <div className="form-group">
            <label htmlFor="inputEmail" className="sr-only">Email address</label>
            <input
              type="email"
              id="inputEmail"
              className="form-control form-control-lg"
              placeholder="Email address"
              value={data.email}
              onChange={(e) => setData('email', e.target.value)} readOnly
              required
            />
          </div>

          <div className="form-group">
            <label htmlFor="inputPassword" className="sr-only">New Password</label>
            <input
              type="password"
              id="inputPassword"
              className="form-control form-control-lg"
              placeholder="New password"
              value={data.password}
              onChange={(e) => setData('password', e.target.value)}
              required
            />
          </div>

          <div className="form-group">
            <label htmlFor="inputConfirmPassword" className="sr-only">Confirm Password</label>
            <input
              type="password"
              id="inputConfirmPassword"
              className="form-control form-control-lg"
              placeholder="Confirm password"
              value={data.password_confirmation}
              onChange={(e) => setData('password_confirmation', e.target.value)}
              required
            />
          </div>

          <button
            className="btn btn-lg btn-primary btn-block"
            type="submit"
            disabled={processing}
          >
            Update Password
          </button>

          <p className="mt-5 mb-3 text-muted">© {new Date().getFullYear()}</p>
        </form>
      </div>
    </div>
  );
}
