import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";

import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditBanner from "./EditBanner";
export default function Banner({banners}){
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, banner: null });
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Title', key: 'title' },
        { header: 'Photo', key: 'photo' },
        { header: 'Status', key: 'status' },
      ];

    const handleDelete = (row) => {
        setDeleteModal({ show: true, banner: row });
    };

    const handleEdit = (row) => {
        fetch(`/admin/edit_banner/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((bannerData) => {
            const formattedData = bannerData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching banner details:', error);
        });
    };

    return(
        <>
        <Toaster />
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Banners</h2>
            <p className="text-muted">Manage Banners</p>
            <Link className="btn mb-4 btn-primary" href="/admin/banners/create">
            Add Banner
            </Link>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={banners} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Banners"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Banners found"
                />
            </Col>
            </Row>
            </Col>
        </Row>

        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, banner: null })}
            onConfirmDelete={() => {
                toast.success("Banner Deleted Successfuly")
            }}
            itemName={deleteModal.banner?.title || 'this banner'}
            itemType="banner"
            deleteEndpoint={`/admin/api/delete_banner/${deleteModal?.banner?.id}`}
        />

        <EditBanner isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}/>
        </>
    );
}