import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";

import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditEventRoom from "./EditEventRoom";

export default function EventRoom({eventRooms}){
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, eventRoom: null });
        const columns = [
                { header: '', key: 'checkbox' },
                { header: 'Name', key: 'name' },
                { header: 'Capacity', key: 'capacity' },
                { header: 'Price FBU', key: 'price_fbu' },
                { header: 'Price USD', key: 'price_usd' },
                { header: 'Price EUR', key: 'price_eur' },
                { header: 'Status', key: 'status' },
            ];
    const handleDelete = (row) => {
        setDeleteModal({ show: true, eventRoom: row });
    };

    const handleEdit = (row) => {
        fetch(`/admin/edit_event_room/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((eventRoomData) => {
            const formattedData = eventRoomData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching event room details:', error);
        });
    };
  
    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Event Rooms</h2>
            <p className="text-muted">Manage conference and event room details</p>
            <Link className="btn mb-4 btn-primary" href="/admin/event_rooms/create">
            Create new Event Room
            </Link>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={eventRooms} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Event Rooms"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Event Rooms found"
                />
            </Col>
            </Row>
            </Col>
        </Row>
        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, eventRoom: null })}
                onConfirmDelete={() => {
                    toast.success("Event Room Deleted Successfully")
                }}
                itemName={deleteModal.eventRoom?.name || 'this event room'}
                itemType="event room"
                deleteEndpoint={`/admin/api/delete_event_room/${deleteModal?.eventRoom?.id}`}
            />
        <EditEventRoom isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}
         />
        </>
    );
}

