import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";

export default function EditFaq({ isOpen, onClose, initialData }){
    const {data, setData, put, processing, errors} = useForm({
        'question': '',
        'answer': '',
        'status': true,
    });

    useEffect(() => {
        if (initialData) {
          setData({
              question: initialData?.question || '',
              answer: initialData?.answer || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_faq/${initialData.id}`, {
            preserveScroll: true,
                onSuccess: formResponse.onSuccess, 
                onError: formResponse.onError, 
            });
    };

    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title={`Edit ${initialData?.question}`} size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}
        >
            <form onSubmit={handleSave}>
            <FormGroup
                id="question"
                label="Question"
                as="textarea"
                value={data.question}
                onChange={(e) => setData("question", e.target.value)}
                rows="4"
                invalidFeedback={errors.question}
                />

            <FormGroup
                id="answer"
                label="Answer"
                as="textarea"
                value={data.answer}
                onChange={(e) => setData("answer", e.target.value)}
                rows="4"
                invalidFeedback={errors.answer}
                />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            </form>

        </Modal>
        </>
    );
}