import Card from "@admin/ui/Card";
import Col from "@admin/ui/Col";
import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { useEffect, useState } from 'react';
import { useFormResponse } from '@/hooks/useFormResponse';
import { Toaster } from "react-hot-toast";

export default function User(){
    const {data,setData,post,processing,errors,reset} = useForm({
        name: '',
        email: '',
        photo:'',
        password: '',
        password_confirmation: '',
        role: '',
        status: true,

    });

    const [roles, setRoles] = useState([]);

    useEffect(() => {
        fetch('/admin/api/roles')
            .then((response) => response.json())
            .then((data) => setRoles(data));
    }, []);

    const handleSuccess = (filename) => {
            setData('photo',filename);
        };

    const handleError = (error) => {
            console.error("Upload error:", error);
        };

    const handleSubmit =(event) =>{
        event.preventDefault();
        const formResponse = useFormResponse(reset);
        post('/admin/api/create_user',{
            ...formResponse,
            preserveScroll: true,
        });
    }

    
    return(
        <>
        <Toaster />
        <Row md="12" >
            <Col lg="12">
            <h2 className="page-title">Create New User</h2>
            <p className="text-muted">Manage Users of Matergo Hotel System</p>
            <Row>
            <Col lg="12">
            <Card md="6" title="User Details">
            <form onSubmit={handleSubmit}>
            <FormGroup label="Name" 
            value={data.name}
            onChange={(e) => setData('name', e.target.value)}
            invalidFeedback={errors.name}
            />
            <FormGroup label="Email" 
            type="email"
            value={data.email}
            onChange={(e) => setData('email', e.target.value)}
            invalidFeedback={errors.email}
            />
            <FormGroup
            id="exampleSelect"
            label="Role"
            as="select"
            value={data.role}
            onChange={(e) => setData("role", e.target.value)}
            required
            >
            <option value="">...</option>
            {roles.map((role) => (
                <option key={role.id} value={role.id}>
                {role.name}
                </option>
            ))}
            </FormGroup>


            <FormGroup label="Password" 
            type="password"
            value={data.password}
            onChange={(e) => setData('password', e.target.value)}
            invalidFeedback={errors.password}
            />

            <FormGroup label="Confirm Password" 
            type="password"
            value={data.password_confirmation}
            onChange={(e) => setData('password_confirmation', e.target.value)}
            invalidFeedback={errors.password_confirmation}
            />

            <br />
            <FileUploadInput label="Upload image (200x200)px" 
            buttonText={"Choose file (200x200)"}
            uploadUrl="/admin/api/user/upload_image"
            onSuccess={handleSuccess}
            onError={handleError}
            />
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            <button type="submit" className="btn btn-primary " disabled={processing}>Save</button>
            </form>
            </Card>
            </Col>
            </Row>
            </Col>
        </Row>
        </>
    );
}