import React from 'react';
import { usePage } from '@inertiajs/react';
import WhatsAppButton from '@user/WhatsAppButton';
import BackToTop from '@user/BackToTop';

export default function Footer(){
    const { siteinfo } = usePage().props;
    
    // Extract company information with fallbacks
    const address = siteinfo?.address || '';
    const phone = siteinfo?.phone || '';
    const email = siteinfo?.email || '';
    const facebook = siteinfo?.facebook || '#';
    const twitter = siteinfo?.x || '#';
    const instagram = siteinfo?.instagram || '#';
    const linkedin = siteinfo?.linkedin || '#';
    
    return(
        <>
        <footer className="section footer-section">
        <div className="container">
            <div className="row mb-4">
            <div className="col-md-6 mb-5">
                <img 
                    src="/assets/user/images/matergo_website_logo.png" 
                    alt="Matergo Hotel" 
                    className="mb-3"
                    style={{ maxHeight: '80px', width: 'auto' }}
                />
                {siteinfo?.about && (
                    <p className="text-muted" style={{ lineHeight: '1.8' }}>
                        {siteinfo.about}
                    </p>
                )}
            </div>
            <div className="col-md-3 mb-5">
                <h5 className="mb-3 text-white">Quick Links</h5>
                <ul className="list-unstyled link">
                <li><a href="/accommodations"><span className="fa fa-chevron-right mr-2"></span>Rooms &amp; Suites</a></li>
                <li><a href="/dining"><span className="fa fa-chevron-right mr-2"></span>Restaurant</a></li>
                <li><a href="/meetings-events"><span className="fa fa-chevron-right mr-2"></span>Meetings &amp; Events</a></li>
                <li><a href="/reservation"><span className="fa fa-chevron-right mr-2"></span>Reservation</a></li>
                <li><a href="/about-us"><span className="fa fa-chevron-right mr-2"></span>About Us</a></li>
                <li><a href="/contact"><span className="fa fa-chevron-right mr-2"></span>Contact Us</a></li>
                </ul>
            </div>
            <div className="col-md-3 mb-5 pr-md-5 contact-info">
                <h5 className="mb-3 text-white">Contact</h5>
                {address && (
                    <p><span className="d-block"><span className="ion-ios-location h5 mr-3 text-primary"></span>Address:</span> <span dangerouslySetInnerHTML={{ __html: address.replace(/\n/g, '<br />') }}></span></p>
                )}
                {phone && (
                    <p><span className="d-block"><span className="ion-ios-telephone h5 mr-3 text-primary"></span>Phone:</span> <span> {phone}</span></p>
                )}
                {email && (
                    <p><span className="d-block"><span className="ion-ios-email h5 mr-3 text-primary"></span>Email:</span> <span> {email}</span></p>
                )}
            </div>
            </div>
            <div className="row pt-5">
            <p className="col-md-6 text-left">
                Copyright &copy;{new Date().getFullYear()} Matergo Hotel | Developed by <a href="https://www.ufanisiafrica.com" target="_blank" >Ufanisi Africa</a>
            </p>
                
            <p className="col-md-6 text-right social">
                {facebook && facebook !== '#' && (
                    <a href={facebook} target="_blank" rel="noopener noreferrer"><span className="fa fa-facebook"></span></a>
                )}
                {twitter && twitter !== '#' && (
                    <a href={twitter} target="_blank" rel="noopener noreferrer"><span className="fa fa-twitter"></span></a>
                )}
                {instagram && instagram !== '#' && (
                    <a href={instagram} target="_blank" rel="noopener noreferrer"><span className="fa fa-instagram"></span></a>
                )}
                {/* {linkedin && linkedin !== '#' && (
                    <a href={linkedin} target="_blank" rel="noopener noreferrer"><span className="fa fa-linkedin"></span></a>
                )} */}
            </p>
            </div>
        </div>
        <WhatsAppButton />
        <BackToTop />
        </footer>
        </>
    );
}