import LanguageSwitcher from "@user/LanguageSwitcher";
import GoogleTranslateWidget from "@user/GoogleTranslateWidget";
import { Link, usePage } from "@inertiajs/react";

export default function Header(){
    const { url } = usePage();
    
    return(
        <>
        <header className="site-header js-site-header">
        <div className="container-fluid">
            <div className="row align-items-center">
            <div className="col-6 col-lg-4 site-logo" data-aos="fade">
                <Link href="/">
                    {/* <span>Matergo Hotel</span> */}
                    <img 
                        src="/assets/user/images/matergo_website_logo.png" 
                        alt="Matergo Hotel" 
                        className="img-fluid" 
                        style={{ maxHeight: '64px' }}
                    />
                </Link>
            </div>
            <div className="col-6 col-lg-8 d-flex align-items-center justify-content-end">

                <GoogleTranslateWidget />
                <LanguageSwitcher />
                
                <div className="site-menu-toggle js-site-menu-toggle" style={{ marginLeft: '15px' }} data-aos="fade">
                <span></span>
                <span></span>
                <span></span>
                </div>
                {/* END menu-toggle */}

                <div className="site-navbar js-site-navbar">
                <nav role="navigation">
                    <div className="container">
                    <div className="row full-height align-items-center">
                        <div className="col-md-6 mx-auto">
                        <ul className="list-unstyled menu">
                            <li className={url === '/' ? 'active' : ''}>
                                <Link href="/">Home</Link>
                            </li>
                            <li className={url.startsWith('/about-us') ? 'active' : ''}>
                                <Link href="/about-us">About Us</Link>
                            </li>
                            <li className={url.startsWith('/rooms') ? 'active' : ''}>
                                <Link href="/rooms">Rooms</Link>
                            </li>
                            <li className={url.startsWith('/reservation') ? 'active' : ''}>
                                <Link href="/reservation">Reservations</Link>
                            </li>
                            <li className={url.startsWith('/dining') ? 'active' : ''}>
                                <Link href="/dining">Dining</Link>
                            </li>
                            <li className={url.startsWith('/meetings-events') ? 'active' : ''}>
                                <Link href="/meetings-events">Meetings & Events</Link>
                            </li>
                            <li className={url.startsWith('/contact') ? 'active' : ''}>
                                <Link href="/contact">Contact</Link>
                            </li>
                        </ul>
                        </div>
                    </div>
                    </div>
                </nav>
                </div>
            </div>
            </div>
        </div>
        </header>
        </>
    );
}