import React from "react";

const TruncatedText = ({ html, maxLength = 94 }) => {
  const extractText = (htmlString) => {
    const tempElement = document.createElement("div");
    tempElement.innerHTML = htmlString;
    return tempElement.textContent || tempElement.innerText || "";
  };

  const text = extractText(html);
  const truncatedText =
    text.length > maxLength ? text.substring(0, maxLength) + "..." : text;

    return <p style={{ wordWrap: "break-word", overflowWrap: "break-word" }}>{truncatedText}</p>;};

export default TruncatedText;
