import React, { useState } from "react";
import Turnstile, { useTurnstile } from "react-turnstile";

const TurnstileComponent = ({ siteKey, onVerify }) => {
  const [token, setToken] = useState("");

  return (
    <Turnstile
      sitekey={siteKey}
      onVerify={(token) => {
        setToken(token);
        onVerify(token);
      }}
      theme="light"
      execution="render"
      style={{ margin: '0.3rem 0' }}
    />
  );
};

export default TurnstileComponent;