import HeroSection from "@user/HeroSection";
import Welcome from "@user/Welcome";
import { Head, usePage, Link } from "@inertiajs/react";
import { formatPriceTriple } from "@/utils/priceFormatter";

export default function AboutUs(){
    const { siteinfo, featuredAccommodations = [], featuredEventRooms = [] } = usePage().props;

    // Get featured accommodations (up to 2)
    const getFeaturedRooms = () => {
        if (featuredAccommodations && featuredAccommodations.length > 0) {
            return featuredAccommodations.slice(0, 2).map((acc) => ({
                id: acc.id,
                name: acc.room_name,
                image: acc.primary_photo ? `/storage/${acc.primary_photo}` : 'https://placehold.co/800x571',
                price: formatPriceTriple(acc.price_fbu, acc.price_usd, acc.price_eur) || 'Price on request',
                description: acc.description || 'Experience comfort and luxury in our beautifully appointed room.',
                type: 'room',
                link: `/accommodations/${acc.id}`,
                bookLink: `/reservation?room=${acc.id}`,
            }));
        }
        return [{
            id: 'placeholder-1',
            name: 'Deluxe Suite',
            image: 'https://placehold.co/800x571',
            price: '199.00',
            description: 'Experience comfort and luxury in our beautifully appointed Deluxe Suite.',
            type: 'room',
            link: '#',
            bookLink: '/reservation',
        }];
    };

    // Get featured event rooms (up to 2)
    const getFeaturedEvents = () => {
        if (featuredEventRooms && featuredEventRooms.length > 0) {
            return featuredEventRooms.slice(0, 2).map((room) => ({
                id: room.id,
                name: room.name,
                image: room.primary_photo ? `/storage/${room.primary_photo}` : 'https://placehold.co/800x571',
                price: formatPriceTriple(room.price_fbu, room.price_usd, room.price_eur) || 'Price on request',
                description: room.short_description || 'Perfect venue for your meetings and events.',
                type: 'event',
                link: `/meetings-events/${room.id}`,
                bookLink: `/reservation?event=${room.id}`,
            }));
        }
        return [{
            id: 'placeholder-event-1',
            name: 'Conference Room',
            image: 'https://placehold.co/800x571',
            price: '150.00',
            description: 'Perfect venue for your meetings, conferences, and special events.',
            type: 'event',
            link: '#',
            bookLink: '/reservation',
        }];
    };

    const featuredRooms = getFeaturedRooms();
    const featuredEvents = getFeaturedEvents();
    
    return(
        <>
        <Head title="About Us" />
        <HeroSection heading="About Us" breadcrumbs={["Home", "About Us"]} />

        {/* History Section */}
        <section className="section">
            <div className="container">
                <div className="row justify-content-center text-center mb-5">
                    <div className="col-md-7">
                        <h2 className="heading" data-aos="fade-up">Our History</h2>
                        <p data-aos="fade-up" data-aos-delay="100">Discover the story behind Matergo Hotel</p>
                    </div>
                </div>
                <div className="row justify-content-center">
                    <div className="col-lg-8" data-aos="fade-up" data-aos-delay="200">
                        <div className="bg-white p-4 p-md-5 border rounded">
                            <p className="text-muted" style={{ lineHeight: '1.9', fontSize: '1.05rem' }}>
                                {siteinfo?.story || 'Matergo Hotel was inaugurated by His Excellency the President of the Republic of Burundi, General Major Evariste NDAYISHIMIYE, on June 10, 2023. It is an international-class hotel, offering high-quality services in accommodation, dining, conference facilities, and much more, at competitive prices. Located in Gitega, the hotel is run by the Bene Terezia Congregation with a mission to combine modern comfort with authentic Burundian hospitality.'}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        {/* Welcome Section (reused, no CTA) */}
        <Welcome showCta={false} />

        {/* Featured Accommodations */}
        <section className="section">
            <div className="container">
                <div className="row justify-content-center text-center mb-5">
                    <div className="col-md-7">
                        <h2 className="heading" data-aos="fade-up">Featured Rooms</h2>
                        <p data-aos="fade-up" data-aos-delay="100">Discover our finest accommodations</p>
                    </div>
                </div>
                <div className="row">
                    {featuredRooms.map((item, index) => (
                        <div key={item.id} className="col-md-6 mb-4" data-aos="fade-up" data-aos-delay={index * 100}>
                            <div className="bg-white border rounded overflow-hidden h-100">
                                <Link href={item.link}>
                                    <img src={item.image} alt={item.name} className="img-fluid w-100" style={{ height: '250px', objectFit: 'cover' }} />
                                </Link>
                                <div className="p-4">
                                    <h4 className="mb-2">
                                        <Link href={item.link} className="text-dark">{item.name}</Link>
                                    </h4>
                                    <p className="text-primary mb-2" style={{ fontSize: '1.25rem', fontWeight: 'bold' }}>
                                        {item.price} <small className="text-muted font-weight-normal">/ night</small>
                                    </p>
                                    <p className="text-muted mb-3">{item.description}</p>
                                    <Link href={item.bookLink} className="btn btn-primary text-white">
                                        Book Now
                                    </Link>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
                <div className="text-center mt-4" data-aos="fade-up">
                    <Link href="/accommodations" className="btn btn-outline-primary">View All Rooms</Link>
                </div>
            </div>
        </section>

        {/* Featured Event Rooms */}
        <section className="section bg-light">
            <div className="container">
                <div className="row justify-content-center text-center mb-5">
                    <div className="col-md-7">
                        <h2 className="heading" data-aos="fade-up">Event Venues</h2>
                        <p data-aos="fade-up" data-aos-delay="100">Host your next event with us</p>
                    </div>
                </div>
                <div className="row">
                    {featuredEvents.map((item, index) => (
                        <div key={item.id} className="col-md-6 mb-4" data-aos="fade-up" data-aos-delay={index * 100}>
                            <div className="bg-white border rounded overflow-hidden h-100">
                                <Link href={item.link}>
                                    <img src={item.image} alt={item.name} className="img-fluid w-100" style={{ height: '250px', objectFit: 'cover' }} />
                                </Link>
                                <div className="p-4">
                                    <h4 className="mb-2">
                                        <Link href={item.link} className="text-dark">{item.name}</Link>
                                    </h4>
                                    <p className="text-primary mb-2" style={{ fontSize: '1.25rem', fontWeight: 'bold' }}>
                                        {item.price} <small className="text-muted font-weight-normal">/ day</small>
                                    </p>
                                    <p className="text-muted mb-3">{item.description}</p>
                                    <Link href={item.bookLink} className="btn btn-primary text-white">
                                        Book Now
                                    </Link>
                                </div>
                            </div>
                        </div>
                    ))}
                </div>
                <div className="text-center mt-4" data-aos="fade-up">
                    <Link href="/meetings-events" className="btn btn-outline-primary">View All Event Rooms</Link>
                </div>
            </div>
        </section>

        {/* Map Section */}
        {siteinfo?.map_embed_code && (
            <div className="map" style={{ marginTop: 0, marginBottom: 0 }}>
                <div dangerouslySetInnerHTML={{ __html: siteinfo.map_embed_code }} style={{ margin: 0, padding: 0, display: 'block' }} />
            </div>
        )}
        </>
    );
}