<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Booking Confirmation - Matergo Hotel</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            line-height: 1.6;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        .email-header {
            background-color: #ffffff;
            padding: 30px 20px;
            text-align: center;
            border-bottom: 3px solid #c9a227;
        }
        .email-header img {
            max-width: 200px;
            height: auto;
            display: block;
            margin: 0 auto;
        }
        .email-container {
            padding: 40px 30px;
        }
        .header-title {
            color: #c9a227;
            font-size: 24px;
            font-weight: 600;
            margin: 0 0 20px 0;
            text-align: center;
        }
        .content {
            color: #333333;
            font-size: 16px;
        }
        .content p {
            margin: 15px 0;
            color: #555555;
        }
        .booking-details {
            background-color: #f9f9f9;
            border-left: 4px solid #c9a227;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        .booking-details h3 {
            color: #c9a227;
            margin-top: 0;
            margin-bottom: 15px;
            font-size: 18px;
        }
        .booking-details p {
            margin: 8px 0;
            color: #333333;
        }
        .booking-reference {
            font-size: 20px;
            font-weight: 600;
            color: #c9a227;
            letter-spacing: 1px;
        }
        .email-footer {
            background-color: #2c2c2c;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .footer-content {
            margin-bottom: 15px;
        }
        .footer-content p {
            margin: 8px 0;
            color: #cccccc;
            font-size: 14px;
        }
        .footer-content strong {
            color: #ffffff;
        }
        .social-links {
            margin: 15px 0;
            padding: 15px 0;
            border-bottom: 1px solid #444444;
        }
        .social-links a {
            display: inline-block;
            margin: 0 10px;
            color: #c9a227;
            text-decoration: none;
            font-size: 14px;
            transition: color 0.3s;
        }
        .social-links a:hover {
            color: #ffffff;
        }
        .social-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 24px;
            height: 24px;
            margin: 0 8px;
            text-decoration: none;
            transition: opacity 0.2s;
        }
        .social-icon:hover {
            opacity: 0.8;
        }
        .social-icon svg {
            width: 24px;
            height: 24px;
        }
        .footer-copyright {
            margin-top: 15px;
            padding-top: 15px;
            color: #999999;
            font-size: 12px;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                padding: 25px 20px;
            }
            .email-header {
                padding: 20px 15px;
            }
            .email-header img {
                max-width: 150px;
            }
            .header-title {
                font-size: 20px;
            }
            .booking-details {
                padding: 15px;
            }
            .email-footer {
                padding: 25px 15px;
            }
            .social-links a {
                display: block;
                margin: 8px 0;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <!-- Header with Logo -->
        <div class="email-header">
            <img src="<?php echo e(asset('assets/user/images/matergo_website_logo.png')); ?>" alt="Matergo Hotel" style="max-width: 200px; height: auto;">
        </div>

        <!-- Main Content -->
        <div class="email-container">
            <h1 class="header-title">Booking Received</h1>
            
            <div class="content">
                <p>Dear <?php echo e($bookingData->full_name); ?>,</p>
                
                <p>Thank you for choosing <strong>Matergo Hotel</strong>. We have received your booking and it is currently pending confirmation.</p>
                
                <div class="booking-details">
                    <h3>Booking Details</h3>
                    <p><strong>Booking Reference:</strong> <span class="booking-reference"><?php echo e($bookingData->booking_reference); ?></span></p>
                    <p><strong>Status:</strong> Pending Confirmation</p>
                    <?php if($bookingData->check_in && $bookingData->check_out): ?>
                    <p><strong>Check-in:</strong> <?php echo e(\Carbon\Carbon::parse($bookingData->check_in)->format('d F Y')); ?></p>
                    <p><strong>Check-out:</strong> <?php echo e(\Carbon\Carbon::parse($bookingData->check_out)->format('d F Y')); ?></p>
                    <?php endif; ?>
                    <p><strong>Number of Guests:</strong> <?php echo e($bookingData->number_of_people); ?></p>
                    <?php if($bookingData->special_request): ?>
                    <p><strong>Special Request:</strong> <?php echo e($bookingData->special_request); ?></p>
                    <?php endif; ?>
                </div>

                <p>We will contact you shortly with more details regarding your booking. Should you have any questions, please feel free to reach out to us.</p>
                
                <p>Best regards,<br><strong>The Matergo Hotel Team</strong></p>
            </div>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <div class="footer-content">
                <?php if($companyInfo): ?>
                    <?php if($companyInfo->address): ?>
                    <p><strong>Address:</strong> <?php echo e($companyInfo->address); ?></p>
                    <?php endif; ?>
                    <?php if($companyInfo->phone): ?>
                    <p><strong>Phone:</strong> <?php echo e($companyInfo->phone); ?></p>
                    <?php endif; ?>
                    <?php if($companyInfo->email): ?>
                    <p><strong>Email:</strong> <a href="mailto:<?php echo e($companyInfo->email); ?>" style="color: #c9a227; text-decoration: none;"><?php echo e($companyInfo->email); ?></a></p>
                    <?php endif; ?>
                    <?php if($companyInfo->whatsapp_marketing || $companyInfo->whatsapp_reception): ?>
                    <p><strong>WhatsApp:</strong> 
                        <?php if($companyInfo->whatsapp_marketing): ?> <?php echo e($companyInfo->whatsapp_marketing); ?> <?php endif; ?>
                        <?php if($companyInfo->whatsapp_marketing && $companyInfo->whatsapp_reception): ?> | <?php endif; ?>
                        <?php if($companyInfo->whatsapp_reception): ?> <?php echo e($companyInfo->whatsapp_reception); ?> <?php endif; ?>
                    </p>
                    <?php endif; ?>
                <?php else: ?>
                    <p><strong>Phone:</strong> +257 22 40 51 77</p>
                    <p><strong>Email:</strong> <a href="mailto:info@matergohotel.bi" style="color: #c9a227; text-decoration: none;">info@matergohotel.bi</a></p>
                <?php endif; ?>
            </div>

            <?php if($companyInfo && ($companyInfo->facebook || $companyInfo->instagram || $companyInfo->x || $companyInfo->linkedin || $companyInfo->youtube)): ?>
            <div class="social-links">
                <p style="color: #ffffff; margin-bottom: 15px; font-weight: 600;">Follow Us</p>
                <?php if($companyInfo->facebook && $companyInfo->facebook !== 'https://facebook.com/'): ?>
                <a href="<?php echo e($companyInfo->facebook); ?>" class="social-icon" target="_blank" title="Facebook">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="#1877f2" xmlns="http://www.w3.org/2000/svg">
                        <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                    </svg>
                </a>
                <?php endif; ?>
                <?php if($companyInfo->instagram && $companyInfo->instagram !== 'https://instagram.com/'): ?>
                <a href="<?php echo e($companyInfo->instagram); ?>" class="social-icon" target="_blank" title="Instagram">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="url(#instagram-gradient)" xmlns="http://www.w3.org/2000/svg">
                        <defs>
                            <linearGradient id="instagram-gradient" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" style="stop-color:#f09433;stop-opacity:1" />
                                <stop offset="25%" style="stop-color:#e6683c;stop-opacity:1" />
                                <stop offset="50%" style="stop-color:#dc2743;stop-opacity:1" />
                                <stop offset="75%" style="stop-color:#cc2366;stop-opacity:1" />
                                <stop offset="100%" style="stop-color:#bc1888;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                        <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                    </svg>
                </a>
                <?php endif; ?>
                <?php if($companyInfo->x && $companyInfo->x !== 'https://twitter.com/'): ?>
                <a href="<?php echo e($companyInfo->x); ?>" class="social-icon" target="_blank" title="X (Twitter)">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="#000000" xmlns="http://www.w3.org/2000/svg">
                        <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>
                    </svg>
                </a>
                <?php endif; ?>
                <?php if($companyInfo->linkedin && $companyInfo->linkedin !== 'https://linkedin.com/'): ?>
                <a href="<?php echo e($companyInfo->linkedin); ?>" class="social-icon" target="_blank" title="LinkedIn">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="#0077b5" xmlns="http://www.w3.org/2000/svg">
                        <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                    </svg>
                </a>
                <?php endif; ?>
                <?php if($companyInfo->youtube): ?>
                <a href="<?php echo e($companyInfo->youtube); ?>" class="social-icon" target="_blank" title="YouTube">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="#ff0000" xmlns="http://www.w3.org/2000/svg">
                        <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                    </svg>
                </a>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <div class="footer-copyright">
                <p>&copy; <?php echo e(date('Y')); ?> Matergo Hotel. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/defenders/public_html/0255_projects/matergo_website/resources/views/emails/booking_confirmation.blade.php ENDPATH**/ ?>